<?php


namespace App\Services;

use Illuminate\Support\Facades\DB;

class DatabaseService
{
    public static function store($databaseName, $username, $password)
    {
        $defaultConnection = DB::connection('mysql'); // Assumes 'mysql' is your master connection

        // Step 1: Create the database
        $defaultConnection->statement("CREATE DATABASE IF NOT EXISTS `{$databaseName}`");

        // Step 2: Create a new user and grant privileges
        $defaultConnection->statement("CREATE USER IF NOT EXISTS '{$username}'@'localhost' IDENTIFIED BY '{$password}'");
        $defaultConnection->statement("GRANT ALL PRIVILEGES ON `{$databaseName}`.* TO '{$username}'@'localhost' WITH GRANT OPTION");
        $defaultConnection->statement("FLUSH PRIVILEGES");

        return true;


    }

    public static function createDatabaseConnection($databaseName)
    {
        $config = config('database.connections.mysql');
        $config['database'] = $databaseName;
        DB::purge('mysql');
        DB::reconnect('mysql', $config);
    }
}






